const sheetName = 'Sheet1'; // تأكد من أن هذا هو الاسم الصحيح لعلامة تبويب الورقة الخاصة بك
const scriptProp = PropertiesService.getScriptProperties();

// قم بتشغيل هذه الدالة مرة واحدة من محرر السكربت لإعداد خاصية معرف جدول البيانات
const initialSetup = () => {
  const activeSpreadsheet = SpreadsheetApp.getActiveSpreadsheet();
  scriptProp.setProperty('key', activeSpreadsheet.getId());
  Logger.log('تم تعيين معرف جدول البيانات: ' + activeSpreadsheet.getId());
}

// التعامل مع طلبات POST - يعالج إرسال النموذج
const doPost = (e) => {
  const lock = LockService.getScriptLock();
  // تقليل وقت الانتظار إلى 5 ثوانٍ
  lock.tryLock(5000); 

  try {
    const doc = SpreadsheetApp.openById(scriptProp.getProperty('key'));
    const sheet = doc.getSheetByName(sheetName);

    if (!sheet) {
      throw new Error(`لم يتم العثور على الورقة "${sheetName}". يرجى التحقق من متغير sheetName.`);
    }

    const headers = sheet.getRange(1, 1, 1, sheet.getLastColumn()).getValues()[0];

    const newRow = headers.map(header => {
      const trimmedHeader = header.trim();
      if (trimmedHeader === 'Date') {
        return new Date();
      }
      
      // معالجة خاصة لحقل الاختصاص
      if (trimmedHeader === 'الاختصاص') {
        // البحث عن البيانات المدمجة أولاً
        if (e.parameter['combinedSpecializations']) {
          return e.parameter['combinedSpecializations'];
        }
        // إذا لم توجد، جمع القيم من الحقول المتعددة
        const specializationArray = e.parameter['الاختصاص[]'];
        if (specializationArray) {
          return Array.isArray(specializationArray) ? specializationArray.join(', ') : specializationArray;
        }
        return '';
      }
      
      // استخدم e.parameter مباشرةً لتبسيط الكود
      return e.parameter[trimmedHeader] || ''; 
    });

    // استخدام appendRow() لتحسين الأداء
    sheet.appendRow(newRow);
    
    // تسجيل البيانات المرسلة بنجاح للمراجعة
    Logger.log('تم إرسال البيانات بنجاح');
    Logger.log('بيانات الاختصاص المرسلة: ' + (e.parameter['combinedSpecializations'] || 'غير موجودة'));
    Logger.log('الصف المضاف: ' + JSON.stringify(newRow));

    // --- منطق إرسال واتساب (اختياري) ---
    // إذا كنت بحاجة إلى إرسال رسائل واتساب من جانب الخادم، قم بتنفيذها هنا
    // مع الأخذ في الاعتبار أنها قد تبطئ الاستجابة.
    // sendWhatsAppMessage(e.parameter['Phone'], 'رسالة جديدة من النموذج'); // مثال

    // إرجاع استجابة JSON سريعة بدلاً من HTML
    return ContentService
      .createTextOutput(JSON.stringify({ 'result': 'success', 'message': 'تم إرسال التقرير بنجاح.' }))
      .setMimeType(ContentService.MimeType.JSON);

  } catch (error) {
    Logger.log('خطأ في doPost: ' + error.toString());
    Logger.log('تتبع المكدس: ' + error.stack);
    Logger.log('معلمات الطلب: ' + JSON.stringify(e.parameter));
    
    // تسجيل خاص لبيانات الاختصاص للمساعدة في التشخيص
    Logger.log('بيانات الاختصاص المدمجة: ' + e.parameter['combinedSpecializations']);
    Logger.log('بيانات الاختصاص المتعددة: ' + JSON.stringify(e.parameter['الاختصاص[]']));
    
    return ContentService
      .createTextOutput(JSON.stringify({ 'result': 'error', 'message': error.toString() }))
      .setMimeType(ContentService.MimeType.JSON);

  } finally {
    lock.releaseLock();
  }
}

// --- دالة إرسال واتساب (مثال مُحسَّن) ---
/*
function sendWhatsAppMessage(phoneNumber, message) {
  const accountSid = PropertiesService.getScriptProperties().getProperty('TWILIO_ACCOUNT_SID');
  const authToken = PropertiesService.getScriptProperties().getProperty('TWILIO_AUTH_TOKEN');
  const twilioPhoneNumber = PropertiesService.getScriptProperties().getProperty('TWILIO_PHONE_NUMBER');

  const endpoint = `https://api.twilio.com/2010-04-01/Accounts/${accountSid}/Messages.json`;

  const payload = {
    'To': `whatsapp:${phoneNumber}`,
    'From': `whatsapp:${twilioPhoneNumber}`,
    'Body': message
  };

  const options = {
    'method': 'post',
    'payload': payload,
    'headers': {
      'Authorization': 'Basic ' + Utilities.base64Encode(`${accountSid}:${authToken}`)
    },
    'muteHttpExceptions': true 
  };
  
  // لا تنتظر الاستجابة لتسريع العملية الرئيسية
  UrlFetchApp.fetch(endpoint, options);
  Logger.log('تم إرسال طلب واتساب.');
}
*/