# نظام إعداد الموظفين الجدد 📋

نظام شامل لإدارة وإعداد ملفات الموظفين (المندوبين) الجدد بشكل تلقائي.

## المميزات ✨

- ✅ واجهة برمجية سهلة الاستخدام لإضافة موظفين جدد
- ✅ نسخ الملفات تلقائياً وإنشاء مجلد منفصل لكل موظف
- ✅ تعديل رابط Google Sheets تلقائياً
- ✅ تغيير اسم المندوب في النموذج
- ✅ تحديد المحافظات المتاحة لكل موظف (محافظة واحدة أو أكثر)
- ✅ إدارة قائمة الموظفين

## طريقة الاستخدام 🚀

### الطريقة الأولى: استخدام الواجهة البرمجية (موصى به) 🎨

1. **افتح صفحة الإدارة:**
   ```
   افتح ملف admin.html في المتصفح
   ```

2. **أضف موظف جديد:**
   - أدخل اسم الموظف
   - أدخل رابط Google Sheets Script URL
   - اختر المحافظات المتاحة للموظف (يمكن اختيار أكثر من محافظة)
   - اضغط "حفظ وإنشاء ملفات الموظف"

3. **ستحصل على 3 ملفات:**
   - `[اسم_الموظف]_config.json` - ملف التكوين
   - `[اسم_الموظف]_instructions.txt` - تعليمات مفصلة
   - `[اسم_الموظف]_command.txt` - أمر Node.js جاهز
   - `[اسم_الموظف]_governorates_code.txt` - كود المحافظات للتعديل اليدوي

4. **تشغيل السكربت:**
   - افتح Terminal أو Command Prompt في مجلد المشروع
   - نفّذ الأمر من ملف `[اسم_الموظف]_command.txt` أو:
   ```
   node setup-employee.js "اسم الموظف" "رابط Google Sheets" "المحافظة1,المحافظة2"
   ```

### الطريقة الثانية: استخدام السكربت مباشرة 💻

1. **تأكد من تثبيت Node.js:**
   ```
   node --version
   ```
   إذا لم يكن مثبتاً، حمّله من: https://nodejs.org

2. **تشغيل السكربت:**
   ```bash
   node setup-employee.js "علي محمد فاضل" "https://script.google.com/macros/s/YOUR_SCRIPT_ID/exec" "بغداد,البصرة"
   ```

3. **النتيجة:**
   - سيتم إنشاء مجلد جديد باسم الموظف
   - جميع الملفات ستكون معدلة وجاهزة للاستخدام
   - افتح `index.html` من المجلد الجديد

## مثال كامل 📝

```bash
# إضافة موظف اسمه "أحمد حسن" يعمل في بغداد والأنبار
node setup-employee.js "أحمد حسن" "https://script.google.com/macros/s/AKfycbz8n1gO4ag5I3Eaelb1RO4DYn8ZXFQWT1f4GBycG5NOrN-BHjt8kXr1x6yF36YYF6zU/exec" "بغداد,الأنبار"
```

## بنية الملفات 📁

```
ali_muhamad/
├── admin.html                 # واجهة الإدارة
├── setup-employee.js          # سكربت Node.js لإعداد الموظفين
├── package.json               # ملف تكوين Node.js
├── index.html                 # ملف النموذج الرئيسي (النسخة الأصلية)
├── style.css
├── ...
└── [اسم_الموظف]/             # مجلد الموظف الجديد
    ├── index.html             # نسخة معدلة من النموذج
    ├── style.css
    ├── employee_config.json   # ملف التكوين
    └── ... (جميع الملفات الأخرى)
```

## المحافظات المتاحة 🗺️

يمكن اختيار واحدة أو أكثر من المحافظات التالية:

- بغداد
- البصرة
- نينوى
- أربيل
- كركوك
- السليمانية
- دهوك
- الأنبار
- ديالى
- كربلاء
- النجف
- واسط
- بابل
- صلاح الدين
- القادسية
- المثنى
- ميسان
- ذي قار

## ملاحظات مهمة ⚠️

1. **رابط Google Sheets:**
   - تأكد من الحصول على رابط Google Apps Script الصحيح
   - يجب أن ينتهي بـ `/exec`
   - مثال: `https://script.google.com/macros/s/AKfycb.../exec`

2. **اسم الموظف:**
   - سيتم استخدام اسم الموظف في:
     - اسم المجلد (سيتم استبدال المسافات بـ _)
     - حقل "اسم المندوب" في النموذج

3. **المحافظات:**
   - يمكن اختيار محافظة واحدة فقط
   - أو أكثر من محافظة مفصولة بفواصل
   - كل محافظة لها قائمة أقسام (قضاء) خاصة بها

4. **النسخ الاحتياطي:**
   - احتفظ بنسخة احتياطية من الملفات الأصلية
   - كل موظف له مجلد منفصل لا يؤثر على الآخرين

## إدارة الموظفين 👥

- عرض جميع الموظفين المسجلين في صفحة الإدارة
- حذف موظف (سيتم حذف بياناته من localStorage)
- تعديل إعدادات موظف موجود (أنشئ موظف جديد بنفس الاسم)

## الدعم والمساعدة 💬

إذا واجهت أي مشاكل:
1. تحقق من صحة رابط Google Sheets
2. تأكد من تثبيت Node.js
3. راجع ملف التعليمات `[اسم_الموظف]_instructions.txt`

---

**تاريخ الإنشاء:** 2024
**الإصدار:** 1.0.0
