# تعليمات إعداد إرسال البيانات إلى Google Sheets

## المشكلة التي تم حلها
كان النموذج لا يرسل البيانات إلى السيرفر بسبب عدم وجود رابط السيرفر في خاصية `action` للنموذج.

## الحلول المطبقة

### 1. إضافة رابط السيرفر للنموذج
تم إضافة خاصية `action` للنموذج مع رابط Google Apps Script:
```html
<form onsubmit="sendForm(event)" id="form" method="POST" action="https://script.google.com/macros/s/YOUR_SCRIPT_ID/exec">
```

### 2. تعديل دالة الإرسال
تم تعديل دالة `sendForm` للسماح بالإرسال الطبيعي للنموذج إلى السيرفر.

## خطوات الإعداد المطلوبة

### 1. إنشاء Google Apps Script
1. اذهب إلى [Google Apps Script](https://script.google.com/)
2. أنشئ مشروع جديد
3. انسخ محتوى ملف `Code.gs.js` إلى المحرر
4. احفظ المشروع

### 2. إنشاء Google Sheets
1. أنشئ جدول بيانات جديد في Google Sheets
2. انسخ ID الجدول من الرابط
3. في Apps Script، شغل دالة `initialSetup()` لربط الجدول

### 3. نشر التطبيق
1. في Apps Script، اضغط على "Deploy" > "New deployment"
2. اختر نوع "Web app"
3. اضبط الإعدادات:
   - Execute as: Me
   - Who has access: Anyone
4. انسخ رابط Web app

### 4. تحديث رابط النموذج
استبدل `YOUR_SCRIPT_ID` في ملف `index.html` برابط Web app الذي حصلت عليه:
```html
action="https://script.google.com/macros/s/YOUR_ACTUAL_SCRIPT_ID/exec"
```

## اختبار النظام
1. افتح ملف `index.html` في المتصفح
2. املأ النموذج
3. اضغط إرسال
4. تحقق من Google Sheets للتأكد من وصول البيانات

## ملاحظات مهمة
- تأكد من أن جميع أسماء الحقول في النموذج تطابق أسماء الأعمدة في Google Sheets
- النظام يمنع الإرسال المكرر باستخدام UUID
- يتم حفظ البيانات مع التاريخ والوقت تلقائياً